import simpleDist.*;
import java.util.*;
import java.lang.*;

public class StockHandler extends Handler{
  public void run() {

    String command="";
    while (command != null){

      if (command.equals("stockLevel"))
        send(getStock());

      if (command.equals("stockHistory"))
        send(getHistory());

      if (command.equals("addStock"))
        send(addStock());

      if (command.equals("sale"))
        send(sale());

      if (command.equals("list"))
        send(list());
      
      if (command.equals("newitem"))
    	  send(newItem());

      command = (String) receive();
      }
    server.disconnect(this);
    }

  public String addStock(){
    String serialNo = (String) receive();
    Integer qty = (Integer) receive();
    String dateTime = (String) receive();

    StockItem item = (StockItem) server.getRepository().get(serialNo);
    
    if (item == null)
      return "Item does not exist";
    
    //Lock the object	
    item = (StockItem) server.lock(serialNo);
    if (item != null){
      String status ="";
 
      //Carry out deposit on the locked account 
      if (item.addStock(qty.intValue(),dateTime))
        status = "Stock Added";
      else
        status = "Failed to add new stock"; 
     server.unlock(serialNo);
     return status; 
   }
   else
     return "Error: stock locked";
    }


  public String sale(){
    String serialNo = (String) receive();
    Integer amt = (Integer) receive();
    String dateTime = (String) receive();

    StockItem item = (StockItem) server.getRepository().get(serialNo);
    
    if (item == null)
      return "Item does not exist";
    
    //Lock the object	
    item = (StockItem) server.lock(serialNo);
    if (item != null){
      String status ="";
 
      //Carry out withdrawal on the locked item
      if (item.debitStock(amt.intValue(),dateTime))
        status = "Sale successful";
      else
        status = "Sale failed"; 
     server.unlock(serialNo);
     return status; 
   }
   else
     return "Error: item locked";
    }

  public String getHistory(){
    String serialNo = (String) receive();
    StockItem item = (StockItem) server.getRepository().get(serialNo);
    
    if (item == null)
      return "Item does not exist";
    
    return item.getHistory();
    }

  public String getStock(){
    String serialNo = (String) receive();
    StockItem item = (StockItem) server.getRepository().get(serialNo);
    
    if (item == null)
      return "Item does not exist";
    
    return item.toString();
    
    }

  public String list(){
    String list ="";
    Iterator listIter = server.getRepository().values().iterator();
    Iterator indxIter = server.getRepository().keySet().iterator();
    while (listIter.hasNext()){
      String s = (String)indxIter.next();
      StockItem i = (StockItem)listIter.next();
      list = list +"\n"+s+" : "+ i;
      }
    return list;
    }
  
  public String newItem(){
	  StockItem newItem = (StockItem) receive();
	  // Check if the object already exists before adding it.
	  // Note that this isn't perfect - another client could add just after we check and before we try
	  // The failure in that case would be silent - the last action to suceed would win and the old
	  // value would be dropped.
	  // http://java.sun.com/j2se/1.5.0/docs/api/java/util/TreeMap.html#put(K, V)
	  
	  if (server.exists(newItem.getserialNo()))
	  {
		  return "Serial number already exists";
	  } else {
		  server.put(newItem.getserialNo(),newItem);
		  return newItem.toString();
	  }
    }
	  
  }